// 2003/03/18 Config.cs
// Copyright (C) Ortana<ortaclient@hotmail.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

using System;
using System.Collections;

namespace NTF.HXD.DOC
{
	/// <summary>
	/// T[o[̐ݒSʂB
	/// </summary>
	public class Config : IConfig
	{

		//Hashtable configList = new Hashtable();

		public Config()
		{
		}


		#region eJeS[̐ݒ
		OptionsConfig optionsConfig;
		public OptionsConfig OptionsConfig
		{
			get
			{
				if( optionsConfig == null )
				{
					return optionsConfig = new OptionsConfig();
				}
				return optionsConfig;
			}
			set
			{
				optionsConfig = value;
			}
		}

		LimitsConfig limitsConfig;
		public LimitsConfig LimitsConfig
		{
			get
			{
				if( limitsConfig == null )
				{
					return limitsConfig =  new LimitsConfig();
				}
				return limitsConfig;
			}
			set
			{
				limitsConfig = value;
			}
		}
	

		TrackerConfig trackerConfig;
		public TrackerConfig TrackerConfig
		{
			get
			{
				if( trackerConfig == null )
				{
					return trackerConfig = new TrackerConfig();
				}
				return trackerConfig;
			}
			set
			{
				trackerConfig = value;
			}
		}

		PathsConfig pathsConfig;
		public PathsConfig PathsConfig
		{
			get
			{
				if( pathsConfig == null )
				{
					return pathsConfig = new PathsConfig();
				}
				return pathsConfig;
			}
			set
			{
				pathsConfig = value;
			}
		}


		FilesConfig filesConfig;
		public FilesConfig FilesConfig
		{
			get
			{
				if( filesConfig == null )
				{
					return filesConfig = new FilesConfig();
				}
				return filesConfig;
			}
			set
			{
				filesConfig = value;
			}
		}

		StringsConfig stringsConfig;
		public StringsConfig StringsConfig
		{
			get
			{
				if( stringsConfig == null )
				{
					return stringsConfig = new StringsConfig();
				}
				return stringsConfig;
			}
			set
			{
				stringsConfig = value;
			}
		}
		
		SpamConfig spamConfig;
		public SpamConfig SpamConfig
		{
			get
			{
				if( spamConfig == null )
				{
					return spamConfig = new SpamConfig();
				}
				return spamConfig;
			}
			set
			{
				spamConfig = value;
			}
		}

		#endregion


		public void Parse(Context context)
		{
			if( context == null )
			{
				return;
			}

			string token = string.Empty;
			string category = string.Empty;

			while(true)
			{
				token = context.NextToken();

				if(token == null)
				{
					break;
				}

				if( token.Equals("{") )
				{
					category = context.PreviousToken();
					if( !context.SkipToken() )
					{
						return;
					}

					switch( category )
					{
						case "options":
							this.OptionsConfig.Parse( context );
							break;

						case "limits":
							this.LimitsConfig.Parse( context );
							break;

						case"tracker":
							this.TrackerConfig.Parse( context );
							break;

						case"paths":
							this.PathsConfig.Parse( context );
							break;

						case"files":
							this.FilesConfig.Parse( context );
							break;

						case"strings":
							this.StringsConfig.Parse( context );
							break;

						case"spam":
							this.SpamConfig.Parse( context );
							break;

						default://̑ݒ͓ǂݔ΂B
							while(true)
							{
								string temp = context.NextToken();
								if( temp == null || temp.Equals("}") )
								{
									break;
								}
							}
							break;
					}
				}
			}



		}

		public System.Text.StringBuilder Save(System.Text.StringBuilder b)
		{
			this.SpamConfig.Save(
				this.StringsConfig.Save(
					this.FilesConfig.Save(
						this.PathsConfig.Save(
							this.TrackerConfig.Save(
								this.LimitsConfig.Save(
									this.OptionsConfig.Save(b)))))));

			return b;
		}
	}
}
